<%@ Page Title="Interpretation & Follow Up" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="LabResultsInterpretation.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.LabResultsInterpretation" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

     <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
        
    <div class = "excludeSaveWarnings">
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
        <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    </div>    
    <br />
    <asp:GridView ID="GridViewLabResultsInterpretation" runat="server" AllowPaging="True" OnRowCommand="SelectActivity" 
        AutoGenerateColumns="False"  DataKeyNames="CaseId,CaseTypeId" PageSize = "10" AllowSorting="true"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty"
        DataSourceID="ObjectDataSourceInterpretationActivities" >
        <Columns>
            <asp:BoundField DataField="CaseId" HeaderText="Workflow ID" SortExpression="WKF_CASE_ID"/>
            <asp:TemplateField HeaderText="Patient Name" SortExpression="LAST_NAME">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PatientName"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Site Number" SortExpression="STATIONNUMBER">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelSite" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("StationNumber"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Facility" SortExpression="INSTITUTION">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="LabelFacility" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Institution"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Specimen Type" SortExpression="CASE_TYPE">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("CaseType"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details"  />
        </Columns>
    </asp:GridView>
    <br />
    <table>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersProviderBio" 
        Text = "Print Completed Provider Letters - Biological Monitoring" 
         onclick="ButtonPrintLettersProviderBio_Click" />
    </td>
    </tr>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersPatientBio" 
        Text = "Print Completed Patient Letters - Biological Monitoring" 
         onclick="ButtonPrintLettersPatientBio_Click" />
    </td>
    </tr>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersProviderFrag" 
        Text = "Print Completed Provider Letters - Fragment Analysis" 
         onclick="ButtonPrintLettersProviderFrag_Click"   />
    </td>
    </tr>
    <tr>
    <td>    <asp:Button runat="server" ID="ButtonPrintLettersPatientFrag" 
        Text = "Print Completed Patient Letters - Fragment Analysis" 
         onclick="ButtonPrintLettersPatientFrag_Click"  />
    </td>
    </tr>
    </table>

    <asp:ObjectDataSource ID="ObjectDataSourceInterpretationActivities" runat="server" 
        SelectMethod="GetInterpretationActivities" 
        SelectCountMethod="GetInterpretationActivitiesCount" 
        EnablePaging="True"
        StartRowIndexParameterName="START_ROW" 
        MaximumRowsParameterName="MAX_ROWS" 
        SortParameterName="SORT_COLUMN"
        OnSelected="ObjectDataSourceInterpretationActivities_Selected" 
        TypeName="VIRP.EFR.BLL.LabResultsInterpretationManager" 
        DataObjectTypeName="VIRP.EFR.BO.LabResultInterpetation"
        OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
            <asp:Parameter Name="CURRENT_USER" Type="String" />
            <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="String" />
            <asp:QueryStringParameter DefaultValue="6" Name="STATUS" QueryStringField="OrderType" Type="Object" />
            <asp:ControlParameter Name = "SEARCH_FIELD" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />
            <asp:Parameter Name="SORT_COLUMN" Type="String" />
            <asp:Parameter Name="START_ROW" Type="Int32" />
            <asp:Parameter Name="MAX_ROWS" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>

</asp:Content>

